/*
    PsyTexx: arm_render.c. ARM render module.
    Copyright (C) 2004  Zolotov Alexandr

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//*** Contact info: Zolotov Alexandr (NightRadio project)
//***               Ekaterinburg. Russia.
//***               Email: observer_page@mail.ru
//***                      warmplace@warmplace.ru
//***                      nightradio@knoppix.ru
//***               WWW: warmplace.ru

#include "PceNativeCall.h"
#include "Standalone.h"
STANDALONE_CODE_RESOURCE_ID (1001);

typedef struct {
	long x;  //x coord
	long y;  //y coord
	long cc; //char code
    long PAT_SCREEN_X;
	long CHAR_SIZE;
	long CHAR_SIZE_Y;
	long char_mode;
	long char_invert;
	unsigned char *bmpP; //screen pointer
	unsigned char *myfontH; //font pointer
} render_info;

int main_callback(const void*,void*,Call68KFuncType*);

int main_callback(const void *emulStateP,
                  void *userData,
                  Call68KFuncType *call68KFuncP)
{
	long aa,bb;
	unsigned char ccc,back=0,fore=255;
	long pnt;

	long x;  //x coord
	long y;  //y coord
	long cc; //char code
    long PAT_SCREEN_X;
	long CHAR_SIZE;
	long CHAR_SIZE_Y;
	unsigned char *bmpP; //screen pointer
	unsigned char *myfontH; //font pointer
	
	render_info *U;
	U=userData;


	x=U->x;
	y=U->y;
	cc=U->cc;
	PAT_SCREEN_X=U->PAT_SCREEN_X;
	CHAR_SIZE=U->CHAR_SIZE;
	CHAR_SIZE_Y=U->CHAR_SIZE_Y;
	bmpP=U->bmpP;
	myfontH=U->myfontH;
	
	
	cc<<=3;
	pnt = (y * PAT_SCREEN_X) + x;

	if(U->char_mode) back=90; else back=0;
	if(U->char_invert)  {fore=back;back=255;}

	if(CHAR_SIZE==8){
		for(aa=0;aa<8;aa++){
		ccc=myfontH[cc];
		for(bb=0;bb<8;bb++){
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;
			ccc<<=1;pnt++;
	    }
		pnt += (PAT_SCREEN_X-8); cc++;
		}
		return 0;
	}
	if(CHAR_SIZE==16){
		for(aa=0;aa<16;aa++){
		ccc=myfontH[cc];
		for(bb=0;bb<16;bb+=2){
			if(ccc&128) {bmpP[pnt]=fore;bmpP[pnt+1]=fore;}
			       else {bmpP[pnt]=back;bmpP[pnt+1]=back;}
			ccc<<=1;pnt+=2;
	    }
		pnt += (PAT_SCREEN_X-16);
		ccc=myfontH[cc];
		if(aa&1) cc++;
		}
		return 0;
	}
	if(CHAR_SIZE==10){
	if(CHAR_SIZE_Y==8){
		for(aa=0;aa<8;aa++){
		ccc=myfontH[cc];
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   ccc<<=1;pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   ccc<<=1;pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   ccc<<=1;pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   ccc<<=1;pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   ccc<<=1;pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   ccc<<=1;pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   pnt++;
		pnt += (PAT_SCREEN_X-10); cc++;
		}
		return 0;
	}
	if(CHAR_SIZE_Y==16){
		for(aa=0;aa<16;aa++){
		ccc=myfontH[cc];
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   ccc<<=1;pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   ccc<<=1;pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   ccc<<=1;pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   ccc<<=1;pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   ccc<<=1;pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   ccc<<=1;pnt++;
			if(ccc&128) bmpP[pnt]=fore; else bmpP[pnt]=back;   pnt++;
		pnt += (PAT_SCREEN_X-10); 
		if(aa&1) cc++;
		}
		return 0;
	}
	}
	
	return 0;
}

